import sys
import math
input = sys.stdin.readline

n = int(input())
vectors = []

for i in range(n):
    x, y = map(int, input().split())
    angle = math.atan2(y, x)
    vectors.append((angle, x, y, i+1))

# Sortiramo po uglu
vectors.sort()

# Dupliramo listu da bismo olakšali circular sliding window
vectors = vectors + [(a + 2*math.pi, x, y, idx) for (a, x, y, idx) in vectors]

max_dist2 = 0
best_indices = []

# Sliding window po uglu (180°)
start = 0
X, Y = 0, 0
current_indices = []
for end in range(len(vectors)):
    angle, x, y, idx = vectors[end]
    X += x
    Y += y
    current_indices.append(idx)
    
    # Dok je ugao veci od 180° od starta, sklanjamo start
    while angle - vectors[start][0] > math.pi:
        _, sx, sy, sidx = vectors[start]
        X -= sx
        Y -= sy
        current_indices.pop(0)
        start += 1
    
    dist2 = X*X + Y*Y
    if dist2 > max_dist2:
        max_dist2 = dist2
        best_indices = current_indices.copy()

print(len(best_indices))
print(*best_indices)